# 帳票設計書 3-Chat Session Export

## 概要

本ドキュメントは、VS CodeのAIチャット機能で行われた会話セッションをJSON形式でエクスポートするChat Session Export機能の帳票出力仕様を定義するものである。

### 本帳票の処理概要

Chat Session Exportは、Copilot Chatやその他のAIチャット機能で行われた会話の履歴をファイルとして保存する機能である。

**業務上の目的・背景**：AIとの会話履歴を保存・共有・バックアップするために使用される。チーム間でのナレッジ共有、会話の再利用、デバッグ目的での会話記録保持等に活用される。

**帳票の利用シーン**：コマンドパレットから「Chat: Export Session...」を実行した際に、ファイル保存ダイアログが表示され、選択した場所にJSON形式で会話セッションが保存される。

**主要な出力内容**：
1. 会話履歴（ユーザー入力とAI応答）
2. 使用されたモデル情報
3. 各メッセージのタイムスタンプ
4. 添付ファイル情報（コンテキスト）
5. 変数参照情報

**帳票の出力タイミング**：ユーザーがエクスポートコマンドを実行し、保存先を選択した際。

**帳票の利用者**：VS Codeユーザー、開発チーム

## 帳票種別

データエクスポート / バックアップファイル

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | Chat View | workbench.view.chat | Chat: Export Session... コマンド |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | `chat-{sessionId}.json` |
| 出力方法 | ファイルダイアログ経由でファイル保存 |
| 文字コード | UTF-8 |

### ファイル拡張子フィルター

| 項目 | 内容 |
|-----|------|
| 表示名 | Chat Session |
| 拡張子 | .json |

## 帳票レイアウト

### レイアウト概要

JSONオブジェクト構造として出力される。

```json
{
  "requesterUsername": "...",
  "requesterAvatarIconUri": "...",
  "responderUsername": "...",
  "responderAvatarIconUri": "...",
  "welcomeMessage": "...",
  "requests": [
    {
      "message": "...",
      "response": [...],
      "result": {...},
      "followups": [...]
    }
  ]
}
```

### ルートオブジェクト

| No | 項目名 | 説明 | データ型 | 必須 |
|----|-------|------|---------|------|
| 1 | requesterUsername | リクエスター名 | string | No |
| 2 | requesterAvatarIconUri | リクエスターアイコンURI | string | No |
| 3 | responderUsername | レスポンダー名 | string | No |
| 4 | responderAvatarIconUri | レスポンダーアイコンURI | string | No |
| 5 | welcomeMessage | ウェルカムメッセージ | string \| IChatWelcomeMessageContent[] | No |
| 6 | requests | 会話リクエスト配列 | IChatRequestModel[] | Yes |

### requestsオブジェクト（会話エントリ）

| No | 項目名 | 説明 | データ型 | 備考 |
|----|-------|------|---------|------|
| 1 | message | ユーザー入力メッセージ | IChatRequestMessage | - |
| 2 | variableData | 変数データ | IChatRequestVariableData | 参照された変数情報 |
| 3 | response | AI応答 | IExportableChatResponseContent[] | 配列形式 |
| 4 | result | 応答結果 | IChatResponseResult | メタデータ |
| 5 | followups | フォローアップ提案 | IChatFollowup[] | 推奨次アクション |

### messageオブジェクト（ユーザー入力）

| No | 項目名 | 説明 | データ型 | 備考 |
|----|-------|------|---------|------|
| 1 | text | メッセージテキスト | string | ユーザー入力全文 |
| 2 | parts | メッセージパーツ | IChatRequestVariableEntry[] | 構造化された入力 |

### responseオブジェクト（AI応答）

| No | 項目名 | 説明 | データ型 | 備考 |
|----|-------|------|---------|------|
| 1 | kind | コンテンツ種別 | string | 'markdownContent', 'codeblockUri', 'inlineReference'等 |
| 2 | content | コンテンツ本体 | MarkdownString \| URI \| Location | 種別により異なる |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| アクティブセッション | 現在のチャットセッションが存在 | Yes |
| 会話履歴あり | requests配列が空でない | No（空でも出力可） |

### インポート時の検証

| 条件名 | 説明 |
|-------|------|
| JSON形式 | 有効なJSON構造 |
| requests存在 | requests配列がundefinedでない |
| requests配列 | requestsがArray型 |

### 改ページ条件

N/A（JSONファイル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | メモリ内のセッションデータを直接取得 | - |

### データ取得元

#### ChatModel

| 参照項目 | 帳票項目との対応 | 取得方法 | 備考 |
|---------|----------------|---------|------|
| requesterUsername | requesterUsername | IChatModel | セッション設定 |
| requesterAvatarIconUri | requesterAvatarIconUri | IChatModel | アイコンURI |
| responderUsername | responderUsername | IChatModel | AI名称 |
| responderAvatarIconUri | responderAvatarIconUri | IChatModel | AIアイコン |
| welcomeMessage | welcomeMessage | IChatModel | ウェルカム文 |
| getRequests() | requests | IChatModel | 会話履歴 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | データ変換のみ | - | 計算なし |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Export Sessionコマンド実行] --> B[exportSession呼び出し]
    B --> C{セッションデータ取得}
    C -->|なし| D[エラー終了]
    C -->|あり| E[toExport変換]
    E --> F[fileDialogService.showSaveDialog]
    F --> G{ユーザー選択}
    G -->|キャンセル| H[処理終了]
    G -->|保存先選択| I[JSON.stringify]
    I --> J[fileService.writeFile]
    J --> K[完了]
```

### インポートフロー

```mermaid
flowchart TD
    A[Import Sessionコマンド実行] --> B[fileDialogService.showOpenDialog]
    B --> C{ファイル選択}
    C -->|キャンセル| D[処理終了]
    C -->|選択| E[fileService.readFile]
    E --> F[JSON.parse]
    F --> G{形式検証}
    G -->|不正| H[エラー通知]
    G -->|正常| I[ChatModel復元]
    I --> J[新規セッション作成]
    J --> K[UIに表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| セッションなし | エクスポート対象が見つからない | (処理中断) | セッションを開始する |
| ファイル選択キャンセル | ダイアログでキャンセル | (処理中断) | - |
| JSONパースエラー | インポートファイルが不正 | Invalid chat session file | 正しいファイルを選択 |
| 書き込みエラー | ファイル保存失敗 | ファイルシステムエラー | 保存先を変更 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 会話数: 数件〜数百件 |
| 目標出力時間 | 2秒以内 |
| 同時出力数上限 | 1件 |

## セキュリティ考慮事項

- 会話内容にはユーザーのコード断片や機密情報が含まれる可能性がある
- エクスポートファイルはローカルに保存され、外部送信は行わない
- インポート時はJSON構造の検証のみで、コンテンツの安全性検証は行わない
- 共有時は機密情報の確認をユーザーに委ねる

## 備考

- エクスポート形式は将来的に変更される可能性がある
- 現在はJSON形式のみサポート
- インポートした会話は新規セッションとして復元される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

エクスポートされるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | chatModel.ts | `src/vs/workbench/contrib/chat/common/chatModel.ts` | IChatModel interface、toExport()メソッド |
| 1-2 | chatService.ts | `src/vs/workbench/contrib/chat/common/chatService.ts` | IExportableChatData interface |

#### Step 2: エントリーポイントを理解する

エクスポート処理の起点を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | chatImportExport.ts | `src/vs/workbench/contrib/chat/browser/actions/chatImportExport.ts` | ExportChatAction (行68-102) |
| 2-2 | chatImportExport.ts | `src/vs/workbench/contrib/chat/browser/actions/chatImportExport.ts` | exportSession()関数 (行38-66) |

**主要処理フロー**:
- **行39-52**: ファイル保存ダイアログの表示と設定
- **行54-64**: JSON変換とファイル書き込み

#### Step 3: インポート処理を理解する

セッションの復元ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | chatImportExport.ts | `src/vs/workbench/contrib/chat/browser/actions/chatImportExport.ts` | ImportChatAction (行104-165) |
| 3-2 | chatImportExport.ts | `src/vs/workbench/contrib/chat/browser/actions/chatImportExport.ts` | isExportedChat() (行167-175) 検証関数 |

### プログラム呼び出し階層図

```
Chat: Export Session コマンド
    │
    ├─ ExportChatAction.run()
    │      │
    │      └─ exportSession()
    │             │
    │             ├─ widget.viewModel?.model.toExport()
    │             │
    │             ├─ fileDialogService.showSaveDialog()
    │             │
    │             ├─ JSON.stringify(data, undefined, 2)
    │             │
    │             └─ fileService.writeFile()
    │
Chat: Import Session コマンド
    │
    └─ ImportChatAction.run()
           │
           ├─ fileDialogService.showOpenDialog()
           │
           ├─ fileService.readFile()
           │
           ├─ JSON.parse()
           │
           ├─ isExportedChat() (検証)
           │
           └─ chatService.startSession() (新規セッション)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

IChatModel           ┌─────────────────────┐
 .toExport() ────────▶│                     │
                     │   exportSession()   │
                     │                     │
                     │ - showSaveDialog()  │──────▶ chat-{id}.json
                     │ - JSON.stringify()  │
                     │ - writeFile()       │
                     └─────────────────────┘

[インポート]

chat-{id}.json       ┌─────────────────────┐
                     │                     │
    ────────────────▶│  ImportChatAction   │
                     │                     │
                     │ - readFile()        │──────▶ 新規ChatModel
                     │ - JSON.parse()      │
                     │ - isExportedChat()  │
                     │ - startSession()    │
                     └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| chatImportExport.ts | `src/vs/workbench/contrib/chat/browser/actions/chatImportExport.ts` | ソース | エクスポート/インポート処理 |
| chatModel.ts | `src/vs/workbench/contrib/chat/common/chatModel.ts` | ソース | チャットモデル定義 |
| chatService.ts | `src/vs/workbench/contrib/chat/common/chatService.ts` | ソース | チャットサービス |
| chat.contribution.ts | `src/vs/workbench/contrib/chat/browser/chat.contribution.ts` | ソース | コマンド登録 |
